/*
 * @(#)CERRelationshipConnectionTool.java  2.0  2008-03-31
 *
 * Copyright (c) 2006-2008 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */
package ch.hslu.cm.cer.diagram;

import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.undo.*;
import org.jhotdraw.draw.*;
import org.jhotdraw.draw.connector.Connector;
import org.jhotdraw.draw.tool.ConnectionTool;
import org.jhotdraw.undo.CompositeEdit;

/**
 * CERRelationshipConnectionTool.
 * 
 * @author Werner Randelshofer
 * @version 2.0 2008-03-31 Reworked for JHotDraw 7.1. 
 * <br>1.0 27. March 2006 Created.
 */
public class CERRelationshipConnectionTool extends ConnectionTool {

    public CERRelationshipConnectionTool(CERConnectionFigure prototype) {
        super(prototype);
    }

    public CERRelationshipConnectionTool(CERConnectionFigure prototype, Map attributes) {
        super(prototype, attributes);
    }

    @Override
    protected boolean canConnect(ConnectionFigure f, Connector startConnector) {
        Figure start = startConnector.getOwner();
        return f.canConnect(startConnector)
                && ((start instanceof CEREntitySetFigure) || (start instanceof CERRelationshipSetFigure));
    }

    @Override
    protected boolean canConnect(ConnectionFigure f, Connector startConnector, Connector endConnector) {
        Figure start = startConnector.getOwner();
        Figure end = endConnector.getOwner();
        return ((start instanceof CEREntitySetFigure) && (end instanceof CEREntitySetFigure))
                || ((start instanceof CEREntitySetFigure) && (end instanceof CERRelationshipSetFigure))
                || ((start instanceof CERRelationshipSetFigure) && (end instanceof CEREntitySetFigure));
    }

    /**
     * Connects the figures if the mouse is released over another
     * figure.
     */
    @Override
    public void mouseReleased(MouseEvent e) {
        if (createdFigure != null && startConnector != null && endConnector != null) {
            Figure start = startConnector.getOwner();
            Figure end = endConnector.getOwner();

            if ((start instanceof CEREntitySetFigure) && (end instanceof CEREntitySetFigure)) {
                // FIXME - Localize edit name
                CompositeEdit creationEdit = new CompositeEdit("Verbindung erstellen");
                getDrawing().fireUndoableEditHappened(creationEdit);

                Point2D.Double startPoint = createdFigure.getStartPoint();
                Point2D.Double p = getView().viewToDrawing(e.getPoint());

                CERRelationshipSetFigure rsf = new CERRelationshipSetFigure();
                rsf.setBounds(
                        new Point2D.Double((startPoint.x + p.x) / 2, (startPoint.y + p.y) / 2),
                        p);
                getDrawing().add(rsf);

                createdFigure.willChange();
                createdFigure.setStartConnector(startConnector);
                createdFigure.setEndConnector(rsf.findCompatibleConnector(
                        (p.y < startPoint.y) ? new CERGeneralizationConnector() : new CERSpecializationConnector(),
                        false));
                createdFigure.setBounds(createdFigure.getStartPoint(), createdFigure.getEndPoint());
                createdFigure.updateConnection();
                createdFigure.changed();

                CERConnectionFigure f2 = (CERConnectionFigure) createdFigure.clone();
                getDrawing().add(f2);
                f2.setStartConnector(rsf.findCompatibleConnector(
                        (p.y < startPoint.y) ? new CERSpecializationConnector() : new CERGeneralizationConnector(),
                        true));
                f2.setEndConnector(endConnector);
                f2.setBounds(f2.getStartConnector().findStart(f2), p);
                f2.updateConnection();



                final Figure addedFigure = createdFigure;
                final Drawing addedDrawing = getDrawing();
                getDrawing().fireUndoableEditHappened(new AbstractUndoableEdit() {

                    @Override
                    public String getPresentationName() {
                        return getPresentationName();
                    }

                    @Override
                    public void undo() throws CannotUndoException {
                        super.undo();
                        addedDrawing.remove(addedFigure);
                    }

                    @Override
                    public void redo() throws CannotRedoException {
                        super.redo();
                        addedDrawing.add(addedFigure);
                    }
                });
                targetFigure = null;
                Point2D.Double anchor = startConnector.getAnchor();
                Rectangle r = new Rectangle(getView().drawingToView(anchor));
                r.grow(getAnchorWidth(), getAnchorWidth());
                fireAreaInvalidated(r);
                anchor = endConnector.getAnchor();
                r = new Rectangle(getView().drawingToView(anchor));
                r.grow(getAnchorWidth(), getAnchorWidth());
                fireAreaInvalidated(r);
                startConnector = endConnector = null;
                createdFigure = null;
                creationFinished(createdFigure);
                getDrawing().fireUndoableEditHappened(creationEdit);
            } else {
                super.mouseReleased(e);
            }
        } else {
            if (isToolDoneAfterCreation()) {
                fireToolDone();
            }
        }
    }
}
